#define USING_HATS									// Uncomment this line to use HATS
#define USING_GRAFFITI									// Uncomment this line to use GRAFFITI
#define USING_SELL									// Uncomment this line to use SELL WEAPONS
#define USING_HOOK									// Uncomment this line to use HOOK
#define USING_BHOP									// Uncomment this line to use BHOP

#include <amxmodx>
#include <amxmisc>
#include <fakemeta_util>
#include <hamsandwich>
#include <cstrike>

#define PLUG "VIP"
#define AUTH "Stewie!"
#define VERS "2.0"

#define VIP_ACCESS ADMIN_ADMIN

#if defined USING_HATS
#include "VIP_XTRAS\hats.inc"
#endif
#if defined USING_GRAFFITI
#include "VIP_XTRAS\graffiti.inc"
#endif
#if defined USING_SELL
#include "VIP_XTRAS\sell.inc"
#endif
#if defined USING_HOOK
#include "VIP_XTRAS\hook.inc"
#endif
#if defined USING_BHOP
#include "VIP_XTRAS\bhop.inc"
#endif

new gVipInfoContents[1024];
new gVipTxtFileLoc[200];
new gConfigFolderLoc[50];
new gVipIniFileLoc[200];

new vip_cost;
new vip_tag;
new vip_adminfriendsname;
new vip_adminemailaddress;
new vip_advertise;
new vip_website_on;
new vip_website;
new vip_irc_on;
new vip_irc;

new SayText;

public plugin_init()
{
	register_plugin(PLUG, VERS, AUTH);
	register_cvar(PLUG, VERS, FCVAR_SERVER|FCVAR_SPONLY, 0.0);
	
	register_clcmd("say /vip", "vip_status", -1, "Shows if you are a VIP or not");
	register_clcmd("say /vipinfo", "show_vip_motd", -1, "Shows the user the VIP information motd");
	register_concmd("amx_addvip", "AddUserToVip", ADMIN_BAN, "Adds a VIP to the external file vip.ini");
	
	vip_adminfriendsname = register_cvar("vip_adminfriendsname", "FriendsName", FCVAR_SPONLY);
	vip_adminemailaddress = register_cvar("vip_adminemailaddress", "Pierodu59162@gmail.com", FCVAR_SPONLY);
	vip_cost = register_cvar("vip_cost", "$10 U.S dollars", FCVAR_SPONLY);
	vip_tag = register_cvar("vip_tag", "[VIP] ", FCVAR_SPONLY);
	vip_advertise = register_cvar("vip_advertise", "1", FCVAR_SPONLY);
	vip_website_on = register_cvar("vip_website_on", "0", FCVAR_SPONLY);
	vip_website = register_cvar("vip_website", "http://WwW.flsteam.CoM : Go Go GO :D", FCVAR_SPONLY);
	vip_irc_on = register_cvar("vip_irc_on", "0", FCVAR_SPONLY);
	vip_irc = register_cvar("vip_irc", "#vip @ gamesurge", FCVAR_SPONLY);
	
	SayText = get_user_msgid("SayText");
	
	register_forward(FM_Spawn, "player_spawn", 1);
	
	get_configsdir(gConfigFolderLoc, 49);
	formatex(gVipInfoContents, 1023, "%s/vipinfo.txt", gConfigFolderLoc);
	formatex(gVipTxtFileLoc, 199, "%s/vipinfo.txt", gConfigFolderLoc);
	formatex(gVipIniFileLoc, 199, "%s/vip.ini", gConfigFolderLoc);
	
	#if defined USING_HATS
	register_hats();
	#endif
	#if defined USING_GRAFFITI
	register_graffiti();
	#endif
	#if defined USING_SELL
	register_sell();
	#endif
	#if defined USING_HOOK
	register_hook();
	#endif
	#if defined USING_BHOP
	register_bhop();
	#endif
}

public plugin_precache()
{
	#if defined USING_HATS
	new cfgDir[32];
	get_configsdir(cfgDir,31);
	formatex(HatFile,63,"%s/HatList.ini",cfgDir);
	
	command_load()
	
	new tmpfile [101];
	for (new i = 1; i < TotalHats; ++i) 
	{
		format(tmpfile, 100, "%s/%s", modelpath, HATMDL[i]);
		if (file_exists (tmpfile)) 
		{
			precache_model(tmpfile);
			server_print("[%s] Precached %s", PLUG_TAG, HATMDL[i]);
		}
		else
		{
			server_print("[%s] Failed to precache %s", PLUG_TAG, tmpfile);
		}
	}
	#endif
	
	#if defined USING_GRAFFITI	
	spriteid = precache_model("sprites/lgtning.spr");
	#endif
	
	#if defined USING_HOOK
	Sbeam = precache_model("sprites/laserbeam.spr")
	#endif
}

public player_spawn(id) 
{
	if(is_user_vip(id))
	{
		fm_set_user_scoreattrib(id, 4)
	}
	else
	{
		advertise_vip(id)
		return PLUGIN_CONTINUE;
	}
	return PLUGIN_CONTINUE;
}

public client_putinserver(id) 
{
	#if defined USING_HOOK
	remove_hook(id)
	#endif
	return PLUGIN_CONTINUE
}

public client_connect(id)
{
	#if defined USING_HATS
	if(g_HatEnt[id] > 0) engfunc(EngFunc_RemoveEntity,g_HatEnt[id])
	g_HatEnt[id] = 0;
	#endif
}

public client_disconnect(id)
{
	#if defined USING_HATS
	if(g_HatEnt[id] > 0) engfunc(EngFunc_RemoveEntity,g_HatEnt[id]);
	g_HatEnt[id] = 0;
	#endif
	#if defined USING_HOOK
	remove_hook(id)
	#endif
	
	remove_task(id);
}

public vip_status(id)
{
	static AdminFriendsName[33];
	static AdminEmailAddress[33];
	static gTag[33];
	
	get_pcvar_string(vip_adminfriendsname, AdminFriendsName, 32);
	get_pcvar_string(vip_adminemailaddress, AdminEmailAddress, 32);
	get_pcvar_string(vip_tag, gTag, 32);
	
	if(is_user_vip(id))
	{
		print(id, "You are a VIP. Thanks for donating");
	}
	else
	{
		print(id, "You are not VIP. Contact ^x03^"%s^"^x01 on steam friends or email ^x03^"%s^"^x01 if you want to donate", AdminFriendsName, AdminEmailAddress)
	}
}

public show_vip_motd(id)
{
	show_motd(id, gVipInfoContents, "VIP Information!");
}

public taskShowInfo(id)
{
	advertise_vip(id);
	
	return PLUGIN_CONTINUE;
}

public advertise_vip(id)
{
	if(get_pcvar_num(vip_advertise) == 1)
	{
		static AdminFriendsName[33];
		static AdminEmailAddress[33];
		static Website[33];
		static Irc[33];		
		static VipCost[33];
		
		get_pcvar_string(vip_adminfriendsname, AdminFriendsName, 32);
		get_pcvar_string(vip_adminemailaddress, AdminEmailAddress, 32);
		get_pcvar_string(vip_website, Website, 32)
		get_pcvar_string(vip_irc, Irc, 32)		
		get_pcvar_string(vip_cost, VipCost, 32);
		
		print(id, "Do you want to be a VIP on this server? It costs ^"^x03%s^x01^" and it has a few benefits!", VipCost);
		print(id, "For more info, please contact ^"^x03%s^x01^" on steam friends or email ^"^x03%s^x01^"", AdminFriendsName, AdminEmailAddress);
		
		if(get_pcvar_num(vip_irc_on) == 1)
		{
			print(id, "Want to get even more info? Join our IRC channel ^"^x03%s^x01^"", Irc)
		}
		if(get_pcvar_num(vip_website_on) == 1)
		{
			print(id, "You can find even more info by going here: ^"^x03%s^x01^"", Website)
		}
	}
	return 1;
}

/***********************************/
/*        Stocks 'N' Stuff         */
/***********************************/
stock fm_set_user_scoreattrib(id, attrib=0)
{
	message_begin(MSG_BROADCAST, get_user_msgid("ScoreAttrib"), _,0);
	write_byte(id);
	write_byte(attrib);
	message_end();
}

stock print(index, const fmt[], any:...)
{
	static gTag[33];
	get_pcvar_string(vip_tag, gTag, 32);
	
	new message[192];
	vformat(message, 191, fmt, 3);
	
	new finalmsg[192];
	formatex(finalmsg, 191, "^x04%s ^x01%s", gTag, message);
	message_begin(MSG_ONE, SayText, _, index);
	write_byte(index);
	write_string(finalmsg);
	message_end();
}

public AddUserToVip(id)
{
	if(get_user_flags(id) & ADMIN_CFG)
	{
		new NewVipsSteamID[21];
		read_argv(1, NewVipsSteamID, 20)
		remove_quotes(NewVipsSteamID);
		trim(NewVipsSteamID);
		write_file(gVipIniFileLoc, NewVipsSteamID);
		
		return 1;
	}
	return 0;
}

bool:is_user_vip(id)
{
	if(file_exists(gVipIniFileLoc))
	{
		new TextLine[33];
		new NoOfChars;
		new szPlayerAuth[33];
		new Lines = file_size(gVipIniFileLoc, 1);
		
		new Left[21], Right[33];
		
		get_user_authid(id, szPlayerAuth, 32);
		
		for(new LineToRead; LineToRead < Lines; LineToRead++)
		{
			read_file(gVipIniFileLoc, LineToRead, TextLine, 32, NoOfChars);
			trim(TextLine);
			
			if(!TextLine[0] || TextLine[0] == ';')
			{
				continue;
			}
			
			if(containi(TextLine, ";") != -1)
			{
				strtok(TextLine, Left, 20, Right, 32, ';', 1);
				
				if(equali(szPlayerAuth, Left))
				{
					return true;
				}
			}
			else
			{
				if(equali(szPlayerAuth, TextLine))
				{
					return true;
				}
			}
		}
	}
	return false;
}