#define PLUG_TAG 	"HATS"
#define PLUG_ADMIN	ADMIN_RCON		//Access flags required to give/remove hats
#define PLUG_ADMINB ADMIN_CHAT		//Access flags required to set personal hat if admin only is enabled

#define menusize 	220
#define modelpath	"models/hat"
#define MAX_HATS 64

new g_HatEnt[33];
new CurrentHat[33];
new CurrentMenu[33];
new HatFile[64];
new MenuPages, TotalHats;
new HATMDL[MAX_HATS][26];
new HATNAME[MAX_HATS][26];
new P_AdminOnly;
new P_AdminHats;

new bool:HATADMIN[MAX_HATS];

public register_hats()
{
	register_concmd("amx_givehat", "Give_Hat", PLUG_ADMIN, "<nick> <mdl #>")
	register_concmd("amx_removehats", "Remove_Hat", PLUG_ADMIN, " - Removes hats from everyone.")
	register_menucmd(register_menuid("\yHat Menu: [Page"),	(1<<0|1<<1|1<<2|1<<3|1<<4|1<<5|1<<6|1<<7|1<<8|1<<9),"MenuCommand")
	register_clcmd("say /hats", "ShowMenu", -1, "Shows Knife menu")
	
	P_AdminOnly		= register_cvar("hat_adminonly",	"0")
	P_AdminHats 	= register_cvar("hat_adminhats",	"0")
}

public ShowMenu(id)
{
	if(is_user_vip(id))
	{
		if ((get_pcvar_num(P_AdminOnly) == 1 && get_user_flags(id) & PLUG_ADMIN) || get_pcvar_num(P_AdminOnly) == 0)
		{
			CurrentMenu[id] = 1
			ShowHats(id)
		}
		else
		{
			client_print(id,print_chat,"[%s] Only admins may currently use this menu.", PLUG_TAG)
		}
		return PLUGIN_HANDLED
	}
	else
	{
		client_print(id, print_chat, "You are not a VIP! Type /vip to find out more");
	}
	return PLUGIN_HANDLED;
}

public ShowHats(id)
{
	new keys = (1<<0|1<<1|1<<2|1<<3|1<<4|1<<5|1<<6|1<<7|1<<8|1<<9)
	
	new szMenuBody[menusize + 1], WpnID
	new nLen = format(szMenuBody, menusize, "\yHat Menu: [Page %i/%i]^n",CurrentMenu[id],MenuPages)
	
	// Get Hat Names And Add Them To The List
	for (new hatid=0; hatid < 8; hatid++) {
		WpnID = ((CurrentMenu[id] * 8) + hatid - 8)
		if (WpnID < TotalHats) {
			nLen += format(szMenuBody[nLen], menusize-nLen, "^n\w%i.\%s %s", hatid + 1, menucolor(id, WpnID), HATNAME[WpnID])
		}
	}
	
	// Next Page And Previous/Close
	if (CurrentMenu[id] == MenuPages) {
		nLen += format(szMenuBody[nLen], menusize-nLen, "^n^n\d9. Next Page")
	} else {
		nLen += format(szMenuBody[nLen], menusize-nLen, "^n^n\w9. Next Page")
	}
	
	if (CurrentMenu[id] > 1) {
		nLen += format(szMenuBody[nLen], menusize-nLen, "^n\w0. Previous Page")
	} else {
		nLen += format(szMenuBody[nLen], menusize-nLen, "^n\w0. Close")
	}
	show_menu(id, keys, szMenuBody, -1)
	return PLUGIN_HANDLED
}

public MenuCommand(id, key) 
{
	switch(key)
	{
		case 8:		//9 - [Next Page]
		{
			if (CurrentMenu[id] < MenuPages) CurrentMenu[id]++
			ShowHats(id)
			return PLUGIN_HANDLED
		}
		case 9:		//0 - [Close]
		{
			CurrentMenu[id]--
			if (CurrentMenu[id] > 0) ShowHats(id)
			return PLUGIN_HANDLED
		}
		default:
		{
			new HatID = ((CurrentMenu[id] * 8) + key - 8)
			if (HatID < TotalHats) {
				if (get_pcvar_num(P_AdminHats) == 0 || HATADMIN[HatID] == false || (get_pcvar_num(P_AdminHats) == 1 && HATADMIN[HatID] == true && get_user_flags(id) & PLUG_ADMINB)) {
					Set_Hat(id,HatID,id)
				} else {
					client_print(id,print_chat,"[%s] This hat is currently set as Admin Only.",PLUG_TAG)
				}
			}
		}
	}
	return PLUGIN_HANDLED
}

public Give_Hat(id)
{
	new smodelnum[5], name[32]
	read_argv(1,name,31)
	read_argv(2,smodelnum,4)
	
	new player = cmd_target(id,name,2)
	if (!player) {
		client_print(id,print_chat,"[%s] Player With That Name Does Not Exist.",PLUG_TAG)
		return PLUGIN_HANDLED
	}
	
	new imodelnum = (str_to_num(smodelnum))
	if (imodelnum > MAX_HATS) return PLUGIN_HANDLED
	
	Set_Hat(player,imodelnum,id)
	
	return PLUGIN_CONTINUE
}

public Remove_Hat(id)
{
	for (new i = 0; i < get_maxplayers(); ++i) {
		if (is_user_connected(i) && g_HatEnt[i] > 0) {
			engfunc(EngFunc_RemoveEntity,g_HatEnt[i])
			g_HatEnt[i] = 0
		}
	}
	client_print(id,print_chat,"[%s] Removed hats from everyone.",PLUG_TAG)
	return PLUGIN_CONTINUE
}

public Set_Hat(player,imodelnum,targeter)
{
	new name[32]
	new tmpfile[101]
	format(tmpfile, 100, "%s/%s", modelpath, HATMDL[imodelnum])
	get_user_name(player, name, 31)
	if (imodelnum == 0) {
		if(g_HatEnt[player] > 0) engfunc(EngFunc_RemoveEntity,g_HatEnt[player])
		g_HatEnt[player] = 0
		if (targeter != 0) {
			client_print(targeter, print_chat, "[%s] Removed hat from %s",PLUG_TAG,name)
		}
	} else if (file_exists(tmpfile)) {
		if(g_HatEnt[player] < 1) {
			g_HatEnt[player] = engfunc(EngFunc_CreateNamedEntity, engfunc(EngFunc_AllocString, "info_target"))
			if(g_HatEnt[player] > 0) 
			{
				set_pev(g_HatEnt[player], pev_movetype, MOVETYPE_FOLLOW)
				set_pev(g_HatEnt[player], pev_aiment, player)
				set_pev(g_HatEnt[player], pev_rendermode, kRenderNormal)
				set_pev(g_HatEnt[player], pev_renderamt, 0.0)
				engfunc(EngFunc_SetModel, g_HatEnt[player], tmpfile)
			}
		} else {
			engfunc(EngFunc_SetModel, g_HatEnt[player], tmpfile)
		}
		CurrentHat[player] = imodelnum
		if (targeter != 0) {
			client_print(targeter, print_chat, "[%s] Set %s on %s",PLUG_TAG,HATNAME[imodelnum],name)
		}
	}
}

public command_load()
{
	if(file_exists(HatFile)) 
	{
		HATMDL[0] = ""
		HATNAME[0] = "None"
		TotalHats = 1
		new TempCrapA[2]
		new sfLineData[128]
		new file = fopen(HatFile,"rt")
		while(file && !feof(file)) 
		{
			fgets(file,sfLineData,127)
			
			// Skip Comment and Empty Lines
			if (containi(sfLineData,";") > -1) continue
			
			// BREAK IT UP!
			parse(sfLineData, HATMDL[TotalHats], 25, HATNAME[TotalHats], 25, TempCrapA, 1)
			
			if (TempCrapA[0] == '1') 
			{
				HATADMIN[TotalHats] = true
			}
			else 
			{
				HATADMIN[TotalHats] = false
			}
			TotalHats += 1
			if(TotalHats >= MAX_HATS) 
			{
				server_print("[%s] Reached hat limit",PLUG_TAG)
				break
			}
		}
		if(file) fclose(file)
	}
	MenuPages = floatround((TotalHats / 8.0), floatround_ceil)
	server_print("[%s] Loaded %i hats, and Generated %i pages",PLUG_TAG,TotalHats,MenuPages)
}

menucolor(id, ItemID)
{
	if (ItemID == CurrentHat[id]) 
	{
		return 'd'
	} 
	else if (HATADMIN[ItemID] && get_pcvar_num(P_AdminHats) == 1) 
	{
		if (get_user_flags(id) & PLUG_ADMINB) 
		{
			return 'y'
		} 
		else 
		{
			return 'R'
		}
	}
	return 'w'
}