#define MAX_WEAPONS 33

new const g_prices[MAX_WEAPONS][] = 
{
	"0",
	"600",
	"0",
	"2750",
	"0",
	"3000",
	"0",
	"1400",
	"3500",
	"0",
	"800",
	"750",
	"1700",
	"4200",
	"2000",
	"2250",
	"500",
	"400",
	"4750",
	"1500",
	"5750",
	"1700",
	"3100",
	"1250",
	"5000",
	"0",
	"650",
	"3500",
	"2500",
	"0",
	"2350",
	"0",
	"0"
}

new cvar, buyzone, divide;

public register_sell()
{
	register_clcmd("say /sell", "cmd_sell")
	register_clcmd("say_team /sell", "cmd_sell")
	
	cvar = register_cvar("SW_enabled", "1")
	buyzone = register_cvar("SW_buyzone", "0")
	divide = register_cvar("SW_divide", "2")
}

public cmd_sell(id)
{
	if(get_pcvar_num(cvar) < 1)
	return PLUGIN_CONTINUE
	
	if(get_pcvar_num(buyzone) == 1 && cs_get_user_buyzone(id) == 0)
	{
		client_print(id, print_chat, "[Sell] You need to be in a buyzone to sell weapons!")
		return PLUGIN_HANDLED
	}
	
	if(!is_user_alive(id))
	{
		client_print(id, print_chat, "[Sell] You need to be alive to sell weapons!") //Prints a angry little message :)
		return PLUGIN_HANDLED
	}
	
	if(!is_user_vip(id))
	{
		client_print(id, print_chat, "You are not a VIP! Type /vip to find out more");
		return PLUGIN_HANDLED;
	}
	
	new temp, weapon = get_user_weapon(id, temp, temp)
	new price = str_to_num(g_prices[weapon])
	
	if(price == 0)
	{
		client_print(id, print_chat, "[Sell] You can't sell that!")
		return PLUGIN_HANDLED
	}
	
	new weaponname[32]
	get_weaponname(weapon, weaponname, 31)

	new oldmoney = cs_get_user_money(id)
	new cash = clamp(oldmoney + (price / get_pcvar_num(divide)), 0, 16000)
	
	fm_strip_user_gun(id, weapon)
	cs_set_user_money(id, cash)
	
	client_print(id, print_chat, "[Sell] You got %d$ for selling a %s", cs_get_user_money(id) - oldmoney, weaponname[7])
	return PLUGIN_HANDLED
}