/* AMX Mod X script. 
* 
*  Jail Break
*  by SpaceDude 
*  email: eayumns@nottingham.ac.uk 
*  MSN: eayumns@nottingham.ac.uk 
*  ICQ: 1615758
*  IRC: Quakenet, nickname: "SpaceDude"
*
*	*******************************************************************************
*  
*	Ported from 1.03 to 1.04 By KingPin(kingpin@onexfx.com). I take no responsibility 
*	for this file in any way. Use at your own risk. No warranties of any kind. 
*	This file mirrored at : http://www.onexfx.com  in the downloads section.
*	
*	*******************************************************************************
*
*
*  Description: 
*
*  This is a CS plugin that adds a new game mode. Here is how it works:
*  Each team has a jail at their respawn, when you kill enemy players they are sent
*  to your jail. In order to win the round you must capture all enemy players in your
*  jail. You can free your team mates from the enemy jail by walking into it without
*  being killed. You get one frag for each team mate rescued.
*
*  Console Commands:
*
*  sv_jailbreak - allows you to enable/disable the plugin, default is 1.
*  Amx_jailbreak - Allows admins to use this without having amx_rcon
*
*  Say Commands For Clients:
*
*  /jailbreak - shows a help file about the plugin.
*
*
*  Revision History
*
*  v1.04: - Ported to AMXX. Added /jailbreak as a say command for help. 
*	  - Needs jailbreak.txt file in "/addons/amxx/custom/jailbreak/"
*	  - Added Amx_jailbreak 1/0 cvar
*
*  v1.03: - players now actually die and respawn
*
*  v1.02: - fixed bug where you could leave the jail area while being "in jail"
*         - it now takes 5 seconds to rescue a team mate, you have to stay inside the jail during this period
*         - if you stay inside the enemy jail when no team mates are in there you will be captured
*         - when put in jail you lose your primary weapon
*         - can only rescue team mates from jail every 30 seconds
*
*  v1.01: - Changed glow effect while in prison (easier to see who is in prison and who isn't)
*         - If you try to escape 3 times in a row you get burried and cannot move until rescued
*         - Fixed bug where dead people could free prisoners
*         - No longer allowed to plant the bomb on de_ maps
*         - Made the jail a little smaller
*         - Changed colors to blue and red
*
*  v1.00: - Initial Version
*
*/ 

#include <amxmodx>
#include <fun>

#define TE_BEAMPOINTS 0
#define TE_SPRITETRAIL 15
#define JAILSIZE 150
#define JAILLIFE 50	// seconds*10
#define JAILBEAMWIDTH 15
#define JAILBEAMNOISE 0
#define JAILBEAMBRIGHTNESS 64
#define RESCUETIME 30.0
#define MAXESCAPEATTEMPTS 3
#define BURYDEPTH 40
#define RESCUECOUNTDOWN 5

new bool:TJailSet	// Terrorist = Team 1
new bool:CTJailSet	// Counter-Terrorist = Team 2
new bool:RestartingRound
new TJailCoords[3]
new CTJailCoords[3]
new PlayerCoords[33]
new bool:IsInJail[33]
new bool:CheckIfStuck[33]
new bool:IsBuried[33]
new EscapeAttempts[33]
new Float:TRescue
new Float:CTRescue

new JailBeam
new gmsgScoreAttrib

public new_round(id){
	if (get_cvar_num("sv_jailbreak")==0)
		return PLUGIN_CONTINUE

	new teamnumber=get_user_team(id)
	if (teamnumber==1 && !TJailSet && is_user_alive(id)){
		get_user_origin(id, TJailCoords)
		TJailSet=true
	}
	else if (teamnumber==2 && !CTJailSet && is_user_alive(id)){
		get_user_origin(id, CTJailCoords)
		CTJailSet=true
	}
	IsInJail[id]=false
	IsBuried[id]=false
	RestartingRound=false
	EscapeAttempts[id]=0

	set_user_godmode(id)
	set_user_rendering(id)

	return PLUGIN_CONTINUE
}

public death(){
	if (get_cvar_num("sv_jailbreak")==0 || RestartingRound)
		return PLUGIN_CONTINUE

	new victim_id = read_data(2)
	if (victim_id){
		new parm[1]
		parm[0]=victim_id
		set_task(0.5,"respawn",852,parm,2)
	}
	return PLUGIN_CONTINUE
}

public create_jail(){
	if (get_cvar_num("sv_jailbreak")==0)
		return PLUGIN_CONTINUE

	new red, green, blue
	new origin[3]
	new x1, y1, x2, y2, height
	new i, j, k
	new shape[4][2] = {{1,1},{-1,1},{-1,-1},{1,-1}}

	for (j=0; j<4; j++){
		height=30*j-30
		for (i=0; i<4; i++){

			x1=shape[i][0]*JAILSIZE
			y1=shape[i][1]*JAILSIZE
			if (i<3){
				x2=shape[i+1][0]*JAILSIZE
				y2=shape[i+1][1]*JAILSIZE
			}
			else{
				x2=shape[0][0]*JAILSIZE
				y2=shape[0][1]*JAILSIZE
			}

			for (k=1; k<3; k++){
				if (k==1){
					origin[0]=TJailCoords[0]
					origin[1]=TJailCoords[1]
					origin[2]=TJailCoords[2]
					red=255
					green=0
					blue=0
				}
				else if (k==2){
					origin[0]=CTJailCoords[0]
					origin[1]=CTJailCoords[1]
					origin[2]=CTJailCoords[2]
					red=0
					green=0
					blue=255
				}
				message_begin( MSG_BROADCAST, SVC_TEMPENTITY )
				write_byte( TE_BEAMPOINTS )
				write_coord(origin[0]+x1)
				write_coord(origin[1]+y1)
				write_coord(origin[2]+height)
				write_coord(origin[0]+x2)
				write_coord(origin[1]+y2)
				write_coord(origin[2]+height)
				write_short(JailBeam)	// model
				write_byte( 0 ) // start frame
				write_byte( 0 ) // framerate
				write_byte( JAILLIFE ) // life
				write_byte( JAILBEAMWIDTH )  // width
				write_byte( JAILBEAMNOISE )   // noise
				write_byte( red )   // r, g, b
				write_byte( green )   // r, g, b
				write_byte( blue )   // r, g, b
				write_byte( JAILBEAMBRIGHTNESS )	// brightness
				write_byte( 0 )		// speed
				message_end()
			}
		}
	}

	return PLUGIN_CONTINUE
}

public check_position(){
	if (get_cvar_num("sv_jailbreak")==0)
		return PLUGIN_CONTINUE

	new origin[3], playerorigin[3], players[32]
	new i, numofplayers, id, teamnumber
	new hudmsg[128]
	new name[32]
	new parm[2]

	get_players(players, numofplayers)
	for (i=0; i<numofplayers; i++){
		id=players[i]
		if (!is_user_alive(id))
			continue
		get_user_origin(id, playerorigin)
		teamnumber = get_user_team(id)
		if (teamnumber==1){
			origin[0]=CTJailCoords[0]
			origin[1]=CTJailCoords[1]
			origin[2]=CTJailCoords[2]
		}
		else if (teamnumber==2){
			origin[0]=TJailCoords[0]
			origin[1]=TJailCoords[1]
			origin[2]=TJailCoords[2]
		}

		if (CheckIfStuck[id] && PlayerCoords[id]==playerorigin[2]){
			origin[0]+=random_num(-JAILSIZE+20,JAILSIZE-20)
			origin[1]+=random_num(-JAILSIZE+20,JAILSIZE-20)
			origin[2]+=1		// Avoid getting teleported all over the place on certain maps
			set_user_origin(id, origin)
			PlayerCoords[id]=origin[2]
			CheckIfStuck[id]=true
		}
		else if (IsInJail[id]){
			CheckIfStuck[id]=false
			if(origin[0]-playerorigin[0] > JAILSIZE || origin[0]-playerorigin[0] < -JAILSIZE ||  
				origin[1]-playerorigin[1] > JAILSIZE || origin[1]-playerorigin[1] < -JAILSIZE ||
				origin[2]-playerorigin[2] > JAILSIZE || origin[2]-playerorigin[2] < -JAILSIZE){
				origin[0]+=random_num(-JAILSIZE+20,JAILSIZE-20)
				origin[1]+=random_num(-JAILSIZE+20,JAILSIZE-20)
				origin[2]+=1		// Avoid getting teleported all over the place on certain maps
				EscapeAttempts[id]++
				if (EscapeAttempts[id]>=MAXESCAPEATTEMPTS){
					get_user_name(id,name,31)
					if (teamnumber==1)
						set_hudmessage(255, 128, 128, -1.0, 0.3, 0, 6.0, 6.0, 0.1, 0.2, 1)
					else if (teamnumber==2)
						set_hudmessage(128, 128, 255, -1.0, 0.3, 0, 6.0, 6.0, 0.1, 0.2, 1)
					IsBuried[id]=true
					CheckIfStuck[id]=false
					origin[2]-=BURYDEPTH
					set_user_origin(id, origin)
					format (hudmsg, 127, "%s has been buried in jail for trying to escape", name)
					show_hudmessage(0,hudmsg)
				}
				else{
					set_user_origin(id, origin)
					PlayerCoords[id]=origin[2]
					CheckIfStuck[id]=true
				}
			}
		}
		else{
			CheckIfStuck[id]=false
			if(!(origin[0]-playerorigin[0] > JAILSIZE || origin[0]-playerorigin[0] < -JAILSIZE ||  
				origin[1]-playerorigin[1] > JAILSIZE || origin[1]-playerorigin[1] < -JAILSIZE ||
				origin[2]-playerorigin[2] > JAILSIZE || origin[2]-playerorigin[2] < -JAILSIZE)){
				if (teamnumber==1 && TRescue < get_gametime())
					TRescue=get_gametime()+RESCUETIME
				else if (teamnumber==2 && CTRescue < get_gametime())
					CTRescue=get_gametime()+RESCUETIME
				else
					continue
				parm[0]=id
				parm[1]=RESCUECOUNTDOWN
				rescue_countdown(parm)
			}
		}
	}

	return PLUGIN_CONTINUE
}

public rescue_countdown(parm[]){
	new id = parm[0]
	new countdown = parm[1]
	new teamnumber = get_user_team(id)
	new hudmsg[128], name[32]
	new teamname[32]
	new numsaved=0
	new origin[3], playerorigin[3], players[32], prisonerorigin[3]
	new j, numofplayers, prisonerid
	get_user_name(id,name,31)

	if (teamnumber==1){
		origin[0]=CTJailCoords[0]
		origin[1]=CTJailCoords[1]
		origin[2]=CTJailCoords[2]
	}
	else if (teamnumber==2){
		origin[0]=TJailCoords[0]
		origin[1]=TJailCoords[1]
		origin[2]=TJailCoords[2]
	}
	get_user_origin(id, playerorigin)
	if(!(origin[0]-playerorigin[0] > JAILSIZE || origin[0]-playerorigin[0] < -JAILSIZE ||  
		origin[1]-playerorigin[1] > JAILSIZE || origin[1]-playerorigin[1] < -JAILSIZE ||
		origin[2]-playerorigin[2] > JAILSIZE || origin[2]-playerorigin[2] < -JAILSIZE ||
		IsInJail[id])){		// If isn't outside the jail and isn't a prisoner
		if (parm[1]!=0){
			parm[1]--
			set_task(1.0,"rescue_countdown",654,parm,2)
		}
	}
	else{
		if (teamnumber==1)
			TRescue=get_gametime()
		else if (teamnumber==2)
			CTRescue=get_gametime()
		return PLUGIN_CONTINUE
	}

	if (countdown){
		if (teamnumber==1)
			set_hudmessage(255, 128, 128, -1.0, 0.25, 0, 1.0, 1.0, 0.1, 0.1, 2)
		else if (teamnumber==2)
			set_hudmessage(128, 128, 255, -1.0, 0.2, 0, 1.0, 1.0, 0.1, 0.1, 3)
		format (hudmsg, 127, "%s is attempting to rescue his team mates... %d", name, countdown)
		show_hudmessage(0,hudmsg)
	}
	else{
		get_players(players, numofplayers)
		for (j=0; j<numofplayers; j++){
			prisonerid=players[j]
			if (get_user_team(id)==get_user_team(prisonerid) && IsInJail[prisonerid] && prisonerid){
				IsInJail[prisonerid]=false
				scoreboard(prisonerid,0)
				set_user_godmode(prisonerid)
				set_user_rendering(prisonerid)
				numsaved++
				if (IsBuried[prisonerid]==true){
					get_user_origin(prisonerid, prisonerorigin)
					prisonerorigin[2]+=BURYDEPTH
					set_user_origin(prisonerid, prisonerorigin)
					PlayerCoords[prisonerid]=prisonerorigin[2]
					CheckIfStuck[prisonerid]=true
				}	
			}
		}
		if (numsaved){
			if (teamnumber==1)
				set_hudmessage(255, 128, 128, -1.0, 0.25, 0, 6.0, 6.0, 0.1, 0.2, 2)
			else if (teamnumber==2)
				set_hudmessage(128, 128, 255, -1.0, 0.2, 0, 6.0, 6.0, 0.1, 0.2, 3)
			if (numsaved==1 && teamnumber==1)
				teamname="Terrorist"
			else if (numsaved==1 && teamnumber==2)
				teamname="Counter-Terrorist"
			else if (numsaved>1 && teamnumber==1)
				teamname="Terrorists"
			else if (numsaved>1 && teamnumber==2)
				teamname="Counter-Terrorists"
			format (hudmsg, 127, "%s rescued %d %s from jail", name, numsaved, teamname)
			show_hudmessage(0,hudmsg)
			set_user_frags(id, get_user_frags(id)+numsaved)
		}
		else{
			if (teamnumber==1)
				set_hudmessage(255, 128, 128, -1.0, 0.25, 0, 6.0, 6.0, 0.1, 0.2, 2)
			else if (teamnumber==2)
				set_hudmessage(128, 128, 255, -1.0, 0.2, 0, 6.0, 6.0, 0.1, 0.2, 3)
			format (hudmsg, 127, "%s had no team mates in jail and has been captured instead", name)
			show_hudmessage(0,hudmsg)
			IsInJail[id]=true
			IsBuried[id]=false
			EscapeAttempts[id]=0

			if (teamnumber==1){
				set_user_rendering(id,kRenderFxGlowShell,0,0,128, kRenderTransTexture, 128)
			}
			else if (teamnumber==2){
				set_user_rendering(id,kRenderFxGlowShell,128,0,0, kRenderTransTexture, 128)
			}
			CheckIfStuck[id]=false
			set_user_health(id, 1124)
			set_user_godmode(id,1)
			engclient_cmd(id,"weapon_knife")
		}
	}
	return PLUGIN_CONTINUE
}

public end_round(){
	if (get_cvar_num("sv_jailbreak")==0)
		return PLUGIN_CONTINUE

	TJailSet=false
	CTJailSet=false
	RestartingRound=true

	return PLUGIN_CONTINUE
}

public scoreboard(id,state){	// 0 - nothing, 1 - dead, 2 - bomb
	message_begin( MSG_ALL, gmsgScoreAttrib,{0,0,0},0)
	write_byte(id)
	write_byte(state)
	message_end()
	return PLUGIN_HANDLED
}

public switch_toknife(id){
	if (get_cvar_num("sv_jailbreak")==0)
		return PLUGIN_CONTINUE

	if (IsInJail[id] || read_data(2)==6)	// 6 = c4
		engclient_cmd(id,"weapon_knife")
	return PLUGIN_CONTINUE
}

public skin_selected(id)
{
	if (get_cvar_num("sv_jailbreak") == 1 && !RestartingRound)
	{
		new parm[2]
		parm[0]=id
		parm[1]=1
		set_task(0.5,"wait_alive",853,parm,2)
	}
	return PLUGIN_CONTINUE
}

public wait_alive(parm[]){
	new id = parm[0]
	if (!is_user_alive(id))
	{
		respawn(parm)
	}
	return PLUGIN_CONTINUE
}

public respawn(parm[])
{
	new id = parm[0]
	if (!get_user_team(id) || !id || RestartingRound)
		return PLUGIN_CONTINUE

	set_task(0.2,"put_in_jail",855,parm,1)
	spawn(id)
	engclient_cmd(id,"weapon_knife")

	return PLUGIN_CONTINUE
}

public put_in_jail(parm[]){
	new id = parm[0]
	new origin[3]

	IsInJail[id]=true
	IsBuried[id]=false
	EscapeAttempts[id]=0
	scoreboard(id,1)
	set_user_godmode(id,1)

	new teamnumber = get_user_team(id)
	if (teamnumber==1){
		origin[0]=CTJailCoords[0]
		origin[1]=CTJailCoords[1]
		origin[2]=CTJailCoords[2]
		set_user_rendering(id,kRenderFxGlowShell,0,0,128, kRenderTransTexture, 128)
	}
	else if (teamnumber==2){
		origin[0]=TJailCoords[0]
		origin[1]=TJailCoords[1]
		origin[2]=TJailCoords[2]
		set_user_rendering(id,kRenderFxGlowShell,128,0,0, kRenderTransTexture, 128)
	}
	origin[0]+=random_num(-JAILSIZE+20,JAILSIZE-20)
	origin[1]+=random_num(-JAILSIZE+20,JAILSIZE-20)
	origin[2]+=1		// Avoid getting teleported all over the place on certain maps
	set_user_origin(id, origin)
	PlayerCoords[id]=origin[2]
	CheckIfStuck[id]=true

	new players[32], numofplayers, targetid, i, talive, ctalive
	talive = 0
	ctalive = 0
	get_players(players, numofplayers)
	for (i=0; i<numofplayers; i++){
		targetid=players[i]
		teamnumber = get_user_team(targetid)
		if (is_user_alive(targetid) && !IsInJail[targetid]){
			if (teamnumber==1)
				++talive
			else if (teamnumber==2)
				++ctalive
		}
	}
	if (!talive || !ctalive){
		for (i=0; i<numofplayers; i++){
			targetid=players[i]
			teamnumber = get_user_team(targetid)
			set_user_godmode(targetid)
			if (teamnumber==1 && !talive)
				user_kill(targetid,1)
			else if (teamnumber==2 && !ctalive)
				user_kill(targetid,1)
		}
	}
	return PLUGIN_CONTINUE
}

public check_alive(){
	if (get_cvar_num("sv_jailbreak")==0)
		return PLUGIN_CONTINUE

	new players[32], numofplayers, targetid, i, talive, ctalive, teamnumber
	talive = 0
	ctalive = 0
	get_players(players, numofplayers)
	for (i=0; i<numofplayers; i++){
		targetid=players[i]
		teamnumber = get_user_team(targetid)
		if (is_user_alive(targetid) && !IsInJail[targetid]){
			if (teamnumber==1)
				++talive
			else if (teamnumber==2)
				++ctalive
		}
	}
	if (!talive || !ctalive){
		for (i=0; i<numofplayers; i++){
			targetid=players[i]
			teamnumber = get_user_team(targetid)
			set_user_godmode(targetid)
			if (teamnumber==1 && !talive)
				user_kill(targetid,1)
			else if (teamnumber==2 && !ctalive)
				user_kill(targetid,1)
		}
	}

	return PLUGIN_CONTINUE
}

public plugin_precache(){
	JailBeam = precache_model("sprites/zbeam4.spr")
	return PLUGIN_CONTINUE
}

//*************  /jailbreak public command Start (KingPin)  *************************

public starthelp(id) 

{
   show_motd(id,"/addons/amxx/custom/jailbreak/jailbreak.txt","Jail Break") 

   return PLUGIN_HANDLED 
} 

//*************  /jailbreak public command end (KingPin)  ****************************

//*************  AMX_JailBreak Cvar Start (KingPin)  *********************************

public admin_jailbreak(id,level){
	if (!(get_user_flags(id)&level)){
			console_print(id,"[AMXX] You have no access to that command.")
			return PLUGIN_HANDLED
		}
	if (read_argc() < 2){
		    new jailbreak_cvar = get_cvar_num("sv_jailbreak")
		    console_print(id,"[AMXX] ^"sv_jailbreak^" is ^"%i^"",jailbreak_cvar)
		    return PLUGIN_HANDLED
	}
	new jailbreak[6]
	read_argv(1,jailbreak,6)
	server_cmd("sv_jailbreak %s",jailbreak)
	console_print(id,"[AMXX] Jailbreak has been set to %s",jailbreak)
	return PLUGIN_HANDLED
}

public check_jailbreak(id){
	new jailbreak = get_cvar_num("sv_jailbreak")
	client_print(id,print_chat,"[AMXX] The jailbreak is set at %i",jailbreak)
	return PLUGIN_HANDLED
}

//*************  AMX_JailBreak Cvar End (KingPin)  *********************************

public plugin_init()
{
	gmsgScoreAttrib = get_user_msgid("ScoreAttrib")
	register_plugin("Jail Break","1.03","SpaceDude & KingPin")
	register_cvar("Jail_Break","1.03",FCVAR_SERVER)
	register_event("SendAudio","end_round","a","2=%!MRAD_terwin","2=%!MRAD_ctwin","2=%!MRAD_rounddraw")
	register_event("ResetHUD", "new_round", "b")
	register_event("DeathMsg","death","a")
	register_event("CurWeapon","switch_toknife","be","1=1","2!29")
	register_clcmd("say /jailbreak","starthelp")
	register_concmd("/jailbreak","starthelp",0,",: Shows a help screen about Jail Break")
	register_concmd("amx_jailbreak","admin_jailbreak",ADMIN_LEVEL_A,"0/1")
	register_menucmd(register_menuid("Terrorist_Select"),1023,"skin_selected")
	register_menucmd(register_menuid("CT_Select"),1023,"skin_selected")
	register_menucmd(-26,1023,"skin_selected")		// VGUI
	register_menucmd(-27,1023,"skin_selected")		// VGUI
	register_cvar("sv_jailbreak","1",0)
	set_task(10.0,"check_alive",456,"",0,"b")
	set_task(2.0,"create_jail",987,"",0,"b")
	set_task(1.0,"check_position",963,"",0,"b")
	return PLUGIN_CONTINUE
}