 /* Ct banner by Drekes.	
  * This plugin is made for Jailbreak servers, but can be used on every server but i don't see the use in that.
  * The point is: when a player is ct on Jailbreak, and he mass freekills or something, you can *ban* him from ct team.
  * So he can't be ct untell you *unban* him from ct. 
  *
  * Commands: amx_ctban <player> "bans him from ct team"
  *
  * Cvars:	ctban_kill 1/0		Kill a player when he gets banned, 1 = kill him		0 = Let him live.
  *		
  * Credits: 
  *				Drekes
  * 			Fysics
  * 			Wrecked_
  *			    Bugsy
  *				Crazyeffect
  *
  * Changelog:
  *				v1.7: Added Kill cvar, Reorganized code to make more readable
  *				v1.6: Added a ban/unban menu, added to amxmodmenu
  *				v1.5: Fixed Admin only bug
  *				v1.4: Added banmenu
  *				v1.3: Multilangual
  *				v1.2: Make banned ct's autojoin T (thanks VEN for auto join on connect plugin)
  *				v1.1: Minor fix (tnx wrecked)
  * 			v1.0: Initial Release
  */

#include <amxmodx>
#include <amxmisc>
#include <cstrike>
#include <celltrie>
#include <fun>

#define PLUGIN "CT banner"
#define VERSION "v1.7"
#define AUTHOR "Drekes"

#define AUTO_TEAM_JOIN_DELAY 0.1
#define TEAM_SELECT_VGUI_MENU_ID 2

new Trie:g_tSteamIDs

new g_szFile[64]
new g_pcvar_team
new g_pcvar_class
new cvar_kill

new bool:is_ct_banned[33]

/*--------Stock--------*/
stock force_team_join(id, menu_msgid, /* const */ team[] = "5", /* const */ class[] = "0") 
{
	static jointeam[] = "jointeam"
	if (class[0] == '0') {
		engclient_cmd(id, jointeam, team)
		return
	}

	static msg_block, joinclass[] = "joinclass"
	msg_block = get_msg_block(menu_msgid)
	set_msg_block(menu_msgid, BLOCK_SET)
	engclient_cmd(id, jointeam, team)
	engclient_cmd(id, joinclass, class)
	set_msg_block(menu_msgid, msg_block)
}
/*--------Plugin init-------------*/
public plugin_init( ) 
{
	register_concmd("amx_banct", "AddCtBan", "ADMIN_CHAT", "<player> - Add player to ctbanlist")
	register_concmd("amx_unbanct", "ADMIN_CHAT", "<player> - Delete ct from ban list")
	register_concmd("amx_ctbanmenu", "ctmainmenu", "ADMIN_CHAT")
        
	register_plugin(PLUGIN, VERSION, AUTHOR)
	
	register_message(get_user_msgid("ShowMenu"), "message_show_menu")
	register_message(get_user_msgid("VGUIMenu"), "message_vgui_menu")
	
	register_dictionary("ctbanner.txt")

	g_pcvar_team = register_cvar("ajc_team", "1")
	g_pcvar_class = register_cvar("ajc_class", "5")
	cvar_kill = register_cvar("ctban_kill", "1")
	
	g_tSteamIDs = TrieCreate();
	copy( g_szFile[ get_localinfo("amxx_datadir", g_szFile, charsmax(g_szFile))], charsmax(g_szFile), "/ct-banlist.ini");
	
	AddMenuItem("CT ban menu", "amx_ctbanmenu", "ADMIN_CHAT", PLUGIN);
	
	loadbanlist()
}

/*------ban list-------*/
public loadbanlist()
{
	new szData[35];

	new f = fopen(g_szFile, "rt");
    
	while(!feof(f))
	{
		fgets( f , szData , charsmax( szData ) );
     
		trim( szData );
        
		if(!szData[0] || szData[0] == ';' || szData[0] == '/' && szData[1] == '/') 
		continue;
            
		TrieSetCell(g_tSteamIDs, szData, 1);
	}
	fclose(f);
}

/*---------New player in server---------*/
public client_putinserver(id)
{
	new szName[33] , szSteamID[35];
    
	get_user_name(id, szName, charsmax(szName));
	get_user_authid(id, szSteamID, charsmax(szSteamID));

	if(TrieKeyExists(g_tSteamIDs, szSteamID))
	{
		client_print(id, print_chat, "* %L", id, "FOUND", szName);
		is_ct_banned[id] = true
	}
	
	else
	{
		client_print(0, print_chat, "* %L", id, "NOT_FOUND", szName);
		is_ct_banned[id] = false
	}
}

/*----------amx_banct-----------*/
public AddCtBan(id, level, cid)
{
	if (!cmd_access(id, level, cid, 2))
		return PLUGIN_HANDLED;

	new szArg[35]
	read_argv(1, szArg, charsmax(szArg))
	new iPlayer = cmd_target(id, szArg, CMDTARGET_ALLOW_SELF | CMDTARGET_NO_BOTS)

	if (iPlayer)
	{
		new szSteamID[35];
		get_user_authid(iPlayer, szSteamID, charsmax(szSteamID));
		if (!TrieKeyExists( g_tSteamIDs , szSteamID ) )
		{
			TrieSetCell(g_tSteamIDs, szSteamID, 1)
			write_file(g_szFile, szSteamID)
			console_print(id, "* %L", id, "ADDED", szSteamID)  
			
			if(get_pcvar_num(cvar_kill) == 1)
			{
				user_kill(iPlayer)
			}
			
			else
			{
				strip_user_weapons(iPlayer)
				give_item(iPlayer, "weapon_knife")
			}
			
			new AdminName[32]
			new PlayerName[32]
			
			get_user_name(id, AdminName, 31)
			get_user_name(iPlayer, PlayerName, 31)
			
			cs_set_user_team(iPlayer, CS_TEAM_T, CS_T_TERROR)

			// client_print(0, print_chat, "* %L", id, "PLAYER_ADDED", AdminName, PlayerName)
		}
		
		else
		{
			console_print( id , "* %L", id, "ALREADY", szSteamID )
		}
		is_ct_banned[iPlayer] = true
	}
	return PLUGIN_HANDLED
}  

/*---------amx_unbanct-------*/
public RemoveCtBan(id, level, cid)
{
    if (!cmd_access(id, level, cid, 2))
        return PLUGIN_HANDLED;
        
    new szArg[35]
    
    if (!read_argv(1, szArg, charsmax(szArg)))
        return PLUGIN_HANDLED;
        
    new iPlayer = cmd_target( id , szArg , CMDTARGET_ALLOW_SELF | CMDTARGET_NO_BOTS )
         
    if ( !iPlayer )
        return PLUGIN_HANDLED;
            
    get_user_authid( iPlayer , szArg , charsmax( szArg ) );
    
    if ( !TrieKeyExists( g_tSteamIDs , szArg ) )
    {
        console_print( id , "* %L" , id, "NOT", szArg );
        return PLUGIN_HANDLED;
    }
    
    new iFileHandle , iFilePos , szLineItem[ 35 ];
    
    iFileHandle = fopen( g_szFile ,"rt" );

    while( !feof( iFileHandle ) )
    {
        fgets( iFileHandle , szLineItem , charsmax( szLineItem ) );
        
        trim( szLineItem );
        
        iFilePos++;

        if( szArg[ 0 ] == ';' )
            continue;
        
        if( equal( szLineItem , szArg ) )
        {
            format( szLineItem , charsmax( szLineItem ) , ";%s" , szLineItem );
            write_file( g_szFile , szLineItem , iFilePos - 1 );
            TrieDeleteKey( g_tSteamIDs , szArg );
            console_print( id , "* %L" , id, "REMOVED", szArg );
            break; 
        }
    }
    is_ct_banned[iPlayer] = false
    fclose(iFileHandle);
    return PLUGIN_HANDLED;
} 

/*----------The message--------*/
public print_message(id)
{
	set_hudmessage(0, 255, 0, 0.30, 0.30, 0, 6.0, 10.0)
	show_hudmessage(id,  "%L", id, "CANT")
}

/*---------ct ban menu--------*/
public ctmainmenu(id, level, cid)
{
	if (!cmd_access(id, level, cid, 1))
		return PLUGIN_HANDLED;

	new ctmainmenu = menu_create("\yCt ban menu:", "ctsubmenu");
	
	menu_additem(ctmainmenu, "\wBan a player from ct", "1", 0)
	menu_additem(ctmainmenu, "\wUnban a player from ct", "2", 0)

	menu_setprop(ctmainmenu, MPROP_EXIT, MEXIT_ALL)
	menu_display(id, ctmainmenu) 
	return PLUGIN_HANDLED;
}

public ctsubmenu(id, ctmainmenu, item)
{
	if (item == MENU_EXIT)
	{
		menu_destroy(ctmainmenu);
		return PLUGIN_HANDLED;
	}
	
	new Data[7], Name[64];
	new Access, Callback;
	menu_item_getinfo(ctmainmenu, item, Access, Data,5, Name, 63, Callback);
	
	new Key = str_to_num(Data);
	
	switch (Key)
	{
		case 1:
		{
			ctbanmenu(id)
		}
		
		case 2: 
		{
			ctunbanmenu(id)
		}
	}
	menu_destroy(ctmainmenu);
	
	return PLUGIN_HANDLED;
}	

public ctbanmenu(id)
{
	new ctbanmenu = menu_create("\yBan a player from ct:", "ctbansubmenu");
	
	new players[32], pnum, tempid;
	new szName[32], szTempid[10];
	
	get_players(players, pnum, "a");
	
	for(new i; i < pnum; i++)
	{
		tempid = players[i];
		
		get_user_name(tempid, szName, 31);
		num_to_str(tempid, szTempid, 9);
		menu_additem(ctbanmenu, szName, szTempid, 0);
	}
	menu_setprop(ctbanmenu, MPROP_EXIT, MEXIT_ALL);
	menu_display(id, ctbanmenu);
	return PLUGIN_HANDLED;
}

public ctbansubmenu(id, ctbanmenu, item)
{
	if( item == MENU_EXIT )
	{
		menu_destroy(ctbanmenu);
		return PLUGIN_HANDLED;
	}
	
	new data[6], iName[64];
	new access, callback;
	menu_item_getinfo(ctbanmenu, item, access, data,5, iName, 63, callback);
	
	new tempid = str_to_num(data);
	
	new szSteamID[ 35 ];
	get_user_authid(tempid, szSteamID, charsmax(szSteamID));
	
	if (!TrieKeyExists(g_tSteamIDs, szSteamID))
	{
		TrieSetCell(g_tSteamIDs , szSteamID , 1 );
		write_file(g_szFile , szSteamID );
		console_print(id , "* %L", id, "ADDED", szSteamID)   
		cs_set_user_team(tempid, CS_TEAM_T, CS_T_TERROR)
		strip_user_weapons(tempid)
		give_item(tempid, "weapon_knife")
	}
	
	else
	{
		console_print(id , "* %L", id, "ALREADY", szSteamID)
	}
		
	new szName[32], szName2[32];
	get_user_name(id, szName, 31);
	get_user_name(tempid, szName2, 31);
	set_hudmessage(0, 255, 255, -1.0, 0.40, 2, 5.0, 8.0, 0.0, 0.0, 10);
	show_hudmessage(0, "admin %s ct-banned %s", szName, szName2);
	
	menu_destroy(ctbanmenu);
	is_ct_banned[tempid] = true
	return PLUGIN_HANDLED;
}

public ctunbanmenu(id)
{
    new ctunbanmenu = menu_create("\yBan a player from ct:", "ctunbansubmenu");
	
    new players[32], pnum, tempid;
    new szName[32], szTempid[10];
	
    get_players(players, pnum, "a");
	
    for(new i; i < pnum; i++)
    {
	tempid = players[i];
		
	get_user_name(tempid, szName, 31);
	num_to_str(tempid, szTempid, 9);
	menu_additem(ctunbanmenu, szName, szTempid, 0);
    }
    menu_setprop(ctunbanmenu, MPROP_EXIT, MEXIT_ALL);
    menu_display(id, ctunbanmenu);
    return PLUGIN_HANDLED;
}

public ctunbansubmenu(id, ctunbanmenu, item)
{
    if( item == MENU_EXIT )
    {
	menu_destroy(ctunbanmenu);
	return PLUGIN_HANDLED;
    }
	
    new data[6], iName[64];
    new access, callback;
    menu_item_getinfo(ctunbanmenu, item, access, data,5, iName, 63, callback);
	
    new tempid = str_to_num(data);

    new szArg[35]
    get_user_authid(tempid, szArg, charsmax(szArg))
    
    if ( !TrieKeyExists( g_tSteamIDs , szArg ) )
    {
        console_print( id , "* %L" , id, "NOT", szArg );
        return PLUGIN_HANDLED;
    }
    
    new iFileHandle , iFilePos , szLineItem[ 35 ];
    
    iFileHandle = fopen( g_szFile ,"rt" );

    while( !feof( iFileHandle ) )
    {
        fgets( iFileHandle , szLineItem , charsmax( szLineItem ) );
        
        trim( szLineItem );
        
        iFilePos++;

        if( szArg[0] == ';' )
            continue;
        
        if( equal( szLineItem , szArg ) )
        {
            format(szLineItem, charsmax(szLineItem), ";%s", szLineItem)
            write_file(g_szFile, szLineItem, iFilePos - 1)
            TrieDeleteKey(g_tSteamIDs, szArg)
            console_print(id, "* %L", id, "REMOVED", szArg)
            break; 
        }
    }
    is_ct_banned[tempid] = false
    fclose(iFileHandle);
    return PLUGIN_HANDLED;
} 

/*-----------detect and block chooseteam menu-----------*/

public message_show_menu(msgid, dest, id) 
{
	if (!is_ct_banned[id])
		return PLUGIN_CONTINUE

	static team_select[] = "#Team_Select"
	static menu_text_code[sizeof team_select]
	get_msg_arg_string(4, menu_text_code, sizeof menu_text_code - 1)
	if (!equal(menu_text_code, team_select))
		return PLUGIN_CONTINUE

	set_force_team_join_task(id, msgid)

	return PLUGIN_HANDLED
}

public message_vgui_menu(msgid, dest, id) 
{
	if (get_msg_arg_int(1) != TEAM_SELECT_VGUI_MENU_ID || !is_ct_banned[id])
		return PLUGIN_CONTINUE

	set_force_team_join_task(id, msgid)

	return PLUGIN_HANDLED
}
set_force_team_join_task(id, menu_msgid) {
	static param_menu_msgid[2]
	param_menu_msgid[0] = menu_msgid
	set_task(AUTO_TEAM_JOIN_DELAY, "task_force_team_join", id, param_menu_msgid, sizeof param_menu_msgid)
}

public task_force_team_join(menu_msgid[], id) {
	if (get_user_team(id))
		return

	static team[2], class[2]
	get_pcvar_string(g_pcvar_team, team, sizeof team - 1)
	get_pcvar_string(g_pcvar_class, class, sizeof class - 1)
	force_team_join(id, menu_msgid[0], team, class)
}
